/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.PathManager;
import com.ibm.hwmca.fw.rcs.conndata.PassthruInfo;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityConstants;
import com.ibm.hwmca.fw.rcs.path.InvalidStateException;
import com.ibm.hwmca.fw.rcs.path.PathCancelReason;
import com.ibm.hwmca.fw.rcs.path.PathCancelledException;
import com.ibm.hwmca.fw.rcs.path.PathCancelledListener;
import com.ibm.hwmca.fw.rcs.path.PathFailedException;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.rcs.path.PathPriority;
import com.ibm.hwmca.fw.rcs.path.PathState;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.rcs.path.TestL2tpPath;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Date;

public class TestPassThruSystemThread
extends Thread
implements OutboundConnectivityConstants,
PathCancelledListener {
    private static final String TRACE_MASKT = "XRCSTPTT";
    private static final String TRACE_MASKF = "XRCSTPTF";
    private static final String TRACE_MASKD = "XRCSTPTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-TsPtThrd");
    private static int uniqueTaskletSource = 0;
    private PanelTasklet originTasklet;
    private PassthruInfo passthruInfo;
    private PathPlatform platform;
    private boolean success = false;
    RcsPath testPath = null;

    public TestPassThruSystemThread(PanelTasklet tasklet, PassthruInfo passthruInfo, PathPlatform platform) {
        super("RCS Test Pass-Through System Thread " + new Date());
        this.originTasklet = tasklet;
        this.passthruInfo = passthruInfo;
        this.platform = platform;
        Object[] subst = new Object[]{passthruInfo.getIpAddress()};
        LocalizableText desc = new LocalizableText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", "TEST_PASSTHRU", subst);
        this.testPath = new TestL2tpPath(platform, PathPriority.HIGH, desc, passthruInfo.getIpAddress());
        Trace.trace(TRACE_MASKT, "<> TestPassThruSystemThread()");
    }

    public void run() {
        Trace.trace(TRACE_MASKT, "-> Test beginning");
        this.updateStatus("TEST_BEGIN", null);
        try {
            this.updateStatus("CONNECTION_WAITING", null);
            this.testPath.waitForAvailability();
            this.testPath.setCancelListener(this);
            this.updateStatus("CONNECTION_OPENING", null);
            this.testPath.open();
            if (this.testPath.getPathIdentifier().getState() == PathState.ACTIVE) {
                this.success = true;
            }
            this.updateStatus("CONNECTION_CLOSING", null);
            this.testPath.close();
        }
        catch (InvalidStateException ise) {
            Trace.trace(TRACE_MASKF, "Invalid path state");
            Object[] subst = new Object[]{""};
            this.updateStatus("CONNECTION_FAILED", subst);
        }
        catch (PathCancelledException pce) {
            Trace.trace(TRACE_MASKF, "Path already canceled");
            this.updateStatus("CONNECTION_CANCELED", null);
        }
        catch (PathFailedException pfe) {
            Trace.trace(TRACE_MASKF, "Path failed");
            Object[] subst = new Object[]{""};
            this.updateStatus("CONNECTION_FAILED", subst);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, this.getStackTrace(e));
            new FrameworkLog(classLogInfo, 1942, e).log();
            Object[] subst = new Object[]{"(" + e.getMessage() + ")"};
            this.updateStatus("CONNECTION_FAILED", subst);
            this.updateStatus("CONNECTION_CLOSING", null);
            this.testPath.close();
        }
        if (this.success) {
            this.updateStatus("TEST_SUCCESS", null);
        } else {
            this.updateStatus("TEST_FAILED", null);
        }
        try {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setSource(this.getUniqueTaskletSource());
            request.setData("Source", "TestPassThruSystemPanel");
            request.setData("Command", "TestComplete");
            this.originTasklet.postRequest("TestPassThruSystemrBean", request);
        }
        catch (TaskletException te) {
            Trace.trace(TRACE_MASKF, this.getStackTrace(te));
            new FrameworkLog(classLogInfo, 1940, te).log();
        }
        Trace.trace(TRACE_MASKT, "<- Test ending");
    }

    public void cancel() {
        Trace.trace(TRACE_MASKT, "-> cancel()");
        try {
            PathManager pathMgr = PathManager.getPathManager();
            pathMgr.cancelPath(this.testPath.getPathIdentifier(), PathCancelReason.USER);
        }
        catch (IllegalArgumentException iae) {
            Trace.trace(TRACE_MASKF, "Path not canceled because it is not managed");
        }
        Trace.trace(TRACE_MASKT, "<- cancel()");
    }

    public void pathCancelled(PathCancelReason reason) {
        Trace.trace(TRACE_MASKT, "-> pathCancelled()");
        this.updateStatus("CONNECTION_CANCELED", null);
        Trace.trace(TRACE_MASKT, "<- pathCancelled()");
    }

    private void updateStatus(String msgKey, Object[] subst) {
        LocalizableText msg = new LocalizableText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", msgKey, subst);
        try {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setSource(this.getUniqueTaskletSource());
            request.setData("Source", "TestPassThruSystemPanel");
            request.setData("Command", "UpdateStatus");
            request.setData("StatusInfo", msg);
            this.originTasklet.postRequest("TestPassThruSystemrBean", request);
        }
        catch (TaskletException te) {
            Trace.trace(TRACE_MASKF, this.getStackTrace(te));
            new FrameworkLog(classLogInfo, 1940, te).log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUniqueTaskletSource() {
        TestPassThruSystemThread testPassThruSystemThread = this;
        synchronized (testPassThruSystemThread) {
            return new Integer(++uniqueTaskletSource);
        }
    }

    public String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        throwable.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }
}

